
function doShowMailDetail(mailid){
	doHideFastReply(mailid);
	var button = $('#mail_detail_button_'+mailid);
	button.text(csHideDetails);
	var infoDetail = $('#mail_info_detail_'+mailid);
	infoDetail.slideDown('fast', function(){
		adjustMailContentSize(mailid, true);
	});
}
function doHideMailDetail(mailid){
	var button = $('#mail_detail_button_'+mailid);
	button.text(csDetails);
	var infoDetail = $('#mail_info_detail_'+mailid);
	infoDetail.slideUp('fast', function(){
		adjustMailContentSize(mailid, true);
	});
}
function toggleMailDetail(mailid){
	var button = $('#mail_detail_button_'+mailid);
	if (button.text() === csHideDetails){
		doHideMailDetail(mailid);
	}else if (button.text() === csDetails){
		doShowMailDetail(mailid);
	}
}
function popupContactMenu(mailid, emails, x, y){
	invokeAppFunction('OnPopupContactMenu', {
		mailid: mailid,
		emails: emails,
		x: event.screenX,
		y: event.screenY
	});
}
function hasSelectedContact(){
	return (selectedEmails && (selectedEmails.length > 0));
}
function doCopyContact(){
	invokeAppFunction('CopyContact', {emails: selectedEmails});
}
function clearContactSelected(){
	selectedEmails = null;
	selectedEmails = [];
	//取消选中样式
	$('.mail_header_receiver_item').removeClass('ui-selected');
}

function makeContactSelectable(mailid){
	var selectArea = $('#mail_header_receiver_panel_'+mailid);
	selectArea.selectable({
		filter: 'li',
		handle: '.mail_header_receiver_item',
		start: function(){
			clearContactSelected();
		}, 
		stop: function(){
			var selectedElements = $('li.ui-selected', $(this));
			var selectedItems = $('.mail_info_expanded_contact_address', selectedElements);
			var index = selectedEmails.length;
			document.selection.empty();
			for (var i=0; i<selectedItems.length; i++){
				var name = $(selectedItems[i]).attr('uName');
				var email = $(selectedItems[i]).attr('email');
				selectedEmails[index++] = {name: name, email: email};
			}
		}
	});
}

var usNotExist = 0;
var usOnline = 1;
var usOffline = 2;
var usAway = 3;
//联系人资料卡浮窗
var g_showContactViewTimer = 0;//计时器
function resetShowContactTask(){
	if (g_showContactViewTimer){
		clearTimeout(g_showContactViewTimer);
		g_showContactViewTimer = 0;
	}
}
function setShowContactTask(name, email, x, y){
	g_showContactViewTimer = setTimeout(function(){
		doShowContactView(name, email, x, y);
	}, 500);
}
function setHideContactView(){
	g_showContactViewTimer = setTimeout(function(){
		doHideContactView();
	}, 500);
}
function prepareShowContactView(name, email, x, y){
	resetShowContactTask();
	var contactViewWidth = $('#contact_view').width();
	var clientWidth = document.documentElement.clientWidth;
	if (x + contactViewWidth >= clientWidth)
		x = clientWidth - contactViewWidth - 15;
	setShowContactTask(name, email, x, y);
}
function doShowContactView(name, email, x, y){
	try{
		var resultString = invokeAppFunction('GetContactInfo', { email: email });
		var contactInfo = parseJSON(resultString);
		var contactExists = contactInfo.contactExists;
		var showName = '';
		var showEmail = '';
		var pic = contactInfo.picture;
		if (contactExists){
			//Change to show details
			$('.desc_add_to_addressbook').text(csAddressDetails);
			showName = contactInfo.name;
			showEmail = contactInfo.email;
		}else{
			//
			$('.desc_add_to_addressbook').text(csAddToAddressBook);
			showName = name;
			showEmail = email;
		}
		$('#contact_view_avatar').attr('src', pic);
		$('#contact_view_info_name').text(showName);
		$('#contact_view_info_name').attr('title', showName);
		$('#contact_view_info_email').text(showEmail);
		$('#contact_view_info_email').attr('title', showEmail);
		if (contactInfo.hasRTXInfo){
			//Show RTX Button
			if ($('#contact_view_rtx').hasClass('hide_ifzero_0')){
				$('#contact_view_rtx').removeClass('hide_ifzero_0');
			}
			var userState = contactInfo.online;
			if (userState == usOnline){
				$('#contact_view_rtx').removeClass('contact_view_rtx_offline');
				$('#contact_view_rtx').addClass('contact_view_rtx_online');
			}else{
				$('#contact_view_rtx').removeClass('contact_view_rtx_online');
				$('#contact_view_rtx').addClass('contact_view_rtx_offline');
			}
			//fill info
			var phone = contactInfo.phone;
			var mobile = contactInfo.mobile;
			var dept = contactInfo.dept;
			
			if (phone != ''){
				$('#contact_view_info_phone').parent().show();
				$('#contact_view_info_phone').text(phone);
				$('#contact_view_info_phone').attr('title', phone);
			}else{
				$('#contact_view_info_phone').parent().hide();
			}
			
			if (mobile != ''){
				$('#contact_view_info_mobile').parent().show();
				$('#contact_view_info_mobile').text(mobile);
				$('#contact_view_info_mobile').attr('title', mobile);
			}else{
				$('#contact_view_info_mobile').parent().hide();
			}

			if (dept != ''){
				$('#contact_view_info_dept').parent().show();
				$('#contact_view_info_dept').text(dept);
				$('#contact_view_info_dept').attr('title', dept);
			}else{
				$('#contact_view_info_dept').parent().hide();
			}
		}else{
			//Hide RTX Button
			if (!$('#contact_view_rtx').hasClass('hide_ifzero_0')){
				$('#contact_view_rtx').addClass('hide_ifzero_0');
			}
			//fill info
			$('#contact_view_info_phone').parent().hide();
			$('#contact_view_info_mobile').parent().hide();
			$('#contact_view_info_dept').parent().hide();
		}
		//set position and show
		var contactView = $('#contact_view');
		contactView.css('left', x+'px');
		contactView.css('top', y+'px');
		contactView.removeClass('hide_ifzero_0');
	}catch(e){
		WriteLog('doShowContactView', e.message);
	}
}

function doHideContactView(){
	var contactView = $('#contact_view');
	contactView.css('left', '-999px');
	contactView.css('top', '-999px');
	contactView.addClass('hide_ifzero_0');
}
function doPopupRTXMenu(email, px, py){
	invokeAppFunction('PopupRTXMenu', {email: email, x: px, y: py});
}

function registerContactViewDelegate(){
	$(document).delegate('#contact_view', 'mouseenter', function(e){
		resetShowContactTask();
	});
	$(document).delegate('#contact_view', 'mouseleave', function(e){
		resetShowContactTask();
		var ptClientString = invokeAppFunction('ScreenToClient', {});
		var ptClient = getPointFromString(ptClientString);
		var element = document.elementFromPoint(ptClient.x, ptClient.y);
		var name = $(element).attr('class');
		if (name.indexOf('contact_view') == -1){
			doHideContactView();
		}
	});
	//button event
	$(document).delegate('#contact_view_bottom', 'selectstart', function(e){
		return false;
	});
	$(document).delegate('#contact_view_rtx', 'selectstart', function(e){
		return false;
	});
	$(document).delegate('#contact_view_rtx', 'click', function(e){
		var px = $(this).offset().left;
		var py = $(this).offset().top + 16;
		var email = $('#contact_view_info_email').text();
		doPopupRTXMenu(email, px, py);
	});
	$(document).delegate('#contact_view_compose_button', 'selectstart', function(e){
		return false;
	});
	$(document).delegate('#contact_view_compose_button', 'click', function(e){
		var obj = $(this);
		var email = $('#contact_view_info_email').text();
		doComposeMail(email);
		doHideContactView();
	});
	$(document).delegate('#contact_view_related_button', 'selectstart', function(e){
		return false;
	});
	$(document).delegate('#contact_view_related_button', 'click', function(e){
		var obj = $(this);
		var email = $('#contact_view_info_email').text();
		doFindRelatedMail(email);
		doHideContactView();
	});
	$(document).delegate('#contact_view_addressbook_button', 'click', function(e){
		return false;
	});
	$(document).delegate('#contact_view_addressbook_button', 'click', function(e){
		var obj = $(this);
		var text = obj.text();
		var name = $('#contact_view_info_name').text();
		var email = $('#contact_view_info_email').text();
		if (text === csAddToAddressBook){
			var div = $(this).parent();
			var x = div.offset().left + div.width() + 30;
			var y = div.offset().top;
			doAddContact(name, email, x, y);
		}else if (text === csAddressDetails){
			doShowContactDetails(email);
			doHideContactView();
		}
	});
}